
# ---------------------------------------------------------------------
library(glue);
library(data.table);
library(lubridate)
library(haven)
library(readxl)
library(statar)
# ---------------------------------------------------------------------


# ---------------------------------------------------------------------
dt1 <- read_excel("./input/EIA_extension.xlsx", sheet = "merged_bilateral")
dt1 <- setDT(dt1)

dt1 <- dt1[, .(date = ymd(date_effective), ISO1, ISO2, EIA_e = type)]
dt1[, year := year(date)]

dt1[, ISOPAIR := paste0(ISO1, ISO2)]

## Duplicating database switching base countries:
dt2 <- dt1[, .(date, ISO1 = ISO2, ISO2 = ISO1, EIA_e, year)]
dt2[, ISOPAIR := paste0(ISO1, ISO2)]


dt_export <- rbind(dt1, dt2)
write_dta(dt_export, "./output/EIA_extended.dta")
# ---------------------------------------------------------------------